// Top Secret Crypto Gold for Windows
//...................................

// Copyright  2000 - 2005 by TAN$TAAFL Software Company
//						      14 Foster St., Banician
//                            Olongapo City 2200
//                            Philippines

// This source code is NOT IN THE PUBLIC DOMAIN and is NOT OPEN SOURCE.
// It is provided solely for the purpose of letting you determine how
// the program works, and that there are no backdoors or hidden code
// in the program. Anyone that wants to use any portion of this code
// in their own program please contact the author at:

//							  MacGregor K. Phillips
//                            PSC 517 Box RS
//                            FPO AP 96517-1000

// Procedures for deleting or wiping files.
//.........................................
#include <windows.h>  
#include "Tsc.h"
#include "ContextHelp.h"
#include "Prototypes.h"
#include <Shlwapi.h>
#include <Commctrl.h>
#include <htmlhelp.h>
#include "Tscmsg.h"
#include "Check.h"
#define STRSAFE_LIB
#include <strsafe.h>

extern	HINSTANCE			hInst;
extern	HWND				hMainWindow;
extern	LPCTSTR				lpszAppName;
extern	LPCTSTR				lpIconPointer;
extern	HWND				hDialogModeLess;
extern	HWND				hDlgCurrent;
extern	BOOL				bProcessInProgress;
extern	BOOL				bCancelOperation;
extern	HWND				hDlgCurrent;
extern	LPTSTR				lpszNA;
extern	LPBYTE				pRandBitsBin;
extern	TCHAR				szFileName[MAX_PATH];
extern	LPBYTE				lpFileExtension;
extern	LPBYTE				lpFileName;
extern	HICON				hIcon;
extern	HICON				hIcon2;
extern	LPTSTR				lpszDateTimeFormat;
extern	LPTSTR				lpszSizeFormat;
extern	NUMBERFMT			nFormatInfo;
extern	SHFILEINFO			shfi1;
extern	LARGE_INTEGER		liHalfPercent;
extern	LARGE_INTEGER		liHalfPercentDup;
extern	TCHAR				szOtpKeyFile[MAX_PATH];
extern	LPCTSTR				lpOtpKeyIcon;
extern	LPBYTE				lpKeyBuffer2;
extern	HFONT				hDlgFont;
extern	HFONT				hDlgFont2;
extern	CONFIG				cfg;
extern	DWORD				dwStringSafeFlag;

// Set to TRUE if we want to wipe files, and set to FALSE
// for deleting files.
//.......................................................
BOOL			bWipeFiles;
BOOL			bUpdateTheStatusBar;
LPBYTE			lpWipeBuffer;
int				iNumberOfFiles;
int				iStepIncrement;
int				iFilesWiped;
LARGE_INTEGER	liStats;
LPTSTR			lpszYes = "Yes";
LPTSTR			lpszNo = "No";
LPTSTR			lpszAttribFormat = "File Attributes: Hidden: %s    System: %s    Read-Only: %s";
DWORD			dwFileAttributes;
BOOL			bSkipTheRest;
TCHAR			szFilesDeleted[] = "%d out of %d Selected Files Deleted.";
TCHAR			szFilesWiped[] = "%d out of %d Selected Files Wiped.";

// Variables for the avi clip.
//............................
BOOL			bAviClipOK;
HWND			hAviClip;

// Delete or wipe one or more files.
//..................................
VOID DeleteWipeFiles(LPBYTE lpBuffer, LPOPENFILENAME lpofn)
{
	OPENFILENAME		ofn;
	ULARGE_INTEGER		uliScratch1;
	ULARGE_INTEGER		uliScratch2;
	ULARGE_INTEGER		uliScratch3;
	LPBYTE				lpFileReturn;
	LPBYTE				lpTempFilePtr;
	LPBYTE				lpFileInsert;
	DWORD				dwOldHelpTopic;
	int					iFileNameLength;
	int					iResult;
	int					iTotalFiles;	
	BOOL				bResult;
	DWORD				dwScratch;
	BOOL				bMoreThanOne;
	BOOL				bUseRandomData;
	DWORD				dwCheckAttributes;
	WIN32_FIND_DATA		wfd;
	HANDLE				hSearch;
	TCHAR				szOutBuffer[132];

	dwCheckAttributes = (FILE_ATTRIBUTE_HIDDEN | FILE_ATTRIBUTE_SYSTEM |
						 FILE_ATTRIBUTE_READONLY);

	bUpdateTheStatusBar = TRUE;

	// We have a process in progress.
	//...............................
	bProcessInProgress = TRUE;
	iFilesWiped = 0;

	// Change to the help topic for wiping or deleting files.
	//.......................................................
	if (bWipeFiles)
	{
		dwOldHelpTopic = IDH_WIPEFILES;
	}
	else
	{
		dwOldHelpTopic = IDH_DELETEFILES;
	}
	dwOldHelpTopic = ChangeHelpTopic(dwOldHelpTopic);
	bAviClipOK = FALSE;
	liStats.QuadPart = 0;

	// If we are not passing parameters in from another procedure we
	// have to get the list of files outselves.
	//..............................................................
	if (!lpBuffer)
	{
		// Initialize the OPENFILENAME structure.
		//.......................................
		InitializeOFN(&ofn,SAVE_SOURCE);

		// Allocate the memory for the return file buffer. This is
		// the maximum sized buffer that the GetOpenFileName common
		// dialog box procedure can handle.
		//.........................................................
		lpFileReturn = AllocateMemory((64 * 1024) - 1);
		if (!lpFileReturn)
		{
			goto DeleteWipeEnd;
		}
		// Initialize with specific information for this procedure.
		//.........................................................
		ofn.lpstrFile = lpFileReturn;
		ofn.nMaxFile = ((64 * 1024) - 1);
		ofn.hwndOwner = hMainWindow;
		ofn.lpstrFilter = TEXT("All Files [*.*]\0*.*\0Adobe PDF Files [.pdf]\0*.pdf\0Tscg Files [.rng;.rsakey;.tsc;.otp;.pad;.tsig;.jrl]\0*.rng;*.rsakey;*.tsc;*.otp;*.pad;*.tsig;*.jrl\0Compressed Files [.pkd;.lha;.zip;.arj;.cab]\0*.pkd;*.lha;*.zip;*.arj;*.cab\0Executable Files [.exe;.dll;.ocx]\0*.exe;*.dll;*.ocx\0Image Files [.bmp;.dib;.gif;.jpg;,ico;,cur]\0*.bmp;*.dib;*.gif;*.jpg;*.ico;*.cur\0Word Documents [.doc]\0*.doc\0Web Pages [.htm;.html;.mht]\0*.htm;*.html;*.mht\0Email Files [.eml]\0*.eml\0Rich Text Format [.rtf]\0*.rtf\0Text Files [.txt]\0*.txt\0Lotus 1-2-3 [.wk1;.wk3]\0*.wk1;*.wk3\0Microsoft Excel Worksheet [.xls;.xlw]\0*.xls;*.xlw\0Windows Write [.wri]\0*.wri\0WordPerfect 5.x [.doc]\0*.doc\0WordPerfect 6.x [.wpd;.doc]\0*.wpd;*.doc\0");
		ofn.nFilterIndex = 1;

		if (bWipeFiles)
		{
			ofn.lpstrTitle = TEXT("Select One or More Files to Wipe");
		}
		else
		{
			ofn.lpstrTitle = TEXT("Select One or More Files to Delete");
		}
		ofn.Flags = (OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST |
					 OFN_ENABLEHOOK | OFN_ENABLESIZING | OFN_SHOWHELP | 
					 OFN_ALLOWMULTISELECT | OFN_HIDEREADONLY);
		ofn.lpstrDefExt = NULL;
		ofn.lpfnHook = MyOFNHookProc;

		// Setup the icon to use in the caption bar.
		//..........................................
		lpIconPointer = lpszAppName;

		// Select the files to wipe or delete.
		//....................................
		if (!GetOpenFileName(&ofn))
		{
			CommDlgBoxErrorProc(IDS_GET_FILES);
			goto DeleteWipeEnd;
		}
	}
	else
	{
		// Setup the file names and ofn structure that we want to wipe from
		// the other procedure.
		//.................................................................
		lpFileReturn = lpBuffer;
		CopyMemory(&ofn,lpofn,sizeof(OPENFILENAME));
	}
	EmptyTheMessageQue();

	// Determine the number of files we have to delete or wipe.
	// Used to setup the progress bar.
	//.........................................................
	lpTempFilePtr = (lpFileReturn + ofn.nFileOffset);
	iNumberOfFiles = 0;
	while(TRUE)
	{
		if (*lpTempFilePtr == 0)
		{
			break;
		}
		iFileNameLength = lstrlen(lpTempFilePtr);
		iNumberOfFiles++;

		// Point to the next file selected. Get past the
		// trailing null byte.
		//..............................................
		lpTempFilePtr += (int)(iFileNameLength + 1);
	}
	// Setup the step increment for the progress bar.
	// Always equals one for this case.
	//...............................................
	iStepIncrement = 1;

	// Store the total number of files.
	//.................................
	iTotalFiles = iNumberOfFiles;

	// Setup the path for our selected files. If only 1 file
	// selected, we have the whole file spec.
	//......................................................
	ZeroMemory(&szFileName,sizeof(szFileName));
	StringCbCatEx((LPTSTR)&szFileName,sizeof(szFileName),lpFileReturn,NULL,NULL,
				   dwStringSafeFlag);

	// Save the dir name.
	//...................
	if (iTotalFiles > 1)
	{
		SaveDirName((LPBYTE)&szFileName,SAVE_SOURCE,FALSE);
	}
	else
	{
		SaveDirName((LPBYTE)&szFileName,SAVE_SOURCE,TRUE);
	}
	// If we have more than one file we have to add a backslash.
	//.........................................................
	bMoreThanOne = FALSE;
	if (iNumberOfFiles > 1)
	{
		bMoreThanOne = TRUE;
		lpFileInsert = PathAddBackslash((LPTSTR)&szFileName);
	}
	lpTempFilePtr = (lpFileReturn + ofn.nFileOffset);

	// If we are wiping files determine the stats for the progress bar
	// based on total file size.
	//................................................................
	if (bWipeFiles)
	{
		// Determine the total size of all the selected files.
		//....................................................
		uliScratch1.QuadPart = 0;
		uliScratch3.QuadPart = 0;

		while(iNumberOfFiles > 0)
		{
			if (bMoreThanOne)
			{
				*lpFileInsert = 0;
				StringCbCatEx(szFileName,sizeof(szFileName),lpTempFilePtr,NULL,NULL,
							  dwStringSafeFlag);
				iFileNameLength = lstrlen(lpTempFilePtr);
				lpTempFilePtr += (int)(iFileNameLength + 1);
			}
			hSearch = FindFirstFile((LPCTSTR)&szFileName,&wfd);

			if (hSearch == INVALID_HANDLE_VALUE)
			{
				ErrorProcedure((LPTSTR)&szFileName,IDS_FINDFIRSTFILE,MB_OK);
				goto DeleteWipeEnd;
			}
			FindClose(hSearch);
			uliScratch2.LowPart = wfd.nFileSizeLow;
			uliScratch2.HighPart = wfd.nFileSizeHigh;

			// If the file is compressed multiply by repeat times 3. If the file
			// is just stored multiply by repeat times 8.
			//..................................................................
			dwScratch = cfg.dwRepeatWipeProc;

			if (wfd.dwFileAttributes & FILE_ATTRIBUTE_COMPRESSED)
			{
				dwScratch *= 3;
			}
			else
			{
				dwScratch *= 8;
			}
			uliScratch3.LowPart = dwScratch;
			uliScratch2.QuadPart = (uliScratch2.QuadPart * uliScratch3.QuadPart);
			uliScratch1.QuadPart += uliScratch2.QuadPart;

			iNumberOfFiles--;
		}
		iNumberOfFiles = iTotalFiles;
		lpTempFilePtr = (lpFileReturn + ofn.nFileOffset);

		// Determine what is a half percent for updating the progress bar.
		//................................................................
		if (uliScratch1.QuadPart < 40000)
		{
			__asm
			{
				xor		edx,edx
				mov		eax,uliScratch1.LowPart
				mov		ecx,200
				div		ecx
				cmp		eax,edx
				jae		L1
				inc		eax
			L1:	mov		liHalfPercent.HighPart,0
				mov		liHalfPercent.LowPart,eax
			}
		}
		else
		{
			liHalfPercent.QuadPart = (uliScratch1.QuadPart / 200);
	
			if (liHalfPercent.QuadPart == 0)
			{
				liHalfPercent.QuadPart = 1;
			}
		}
		liHalfPercentDup.QuadPart = liHalfPercent.QuadPart;

		// Allocate the memory for the wipe buffer.
		//.........................................
		lpWipeBuffer = AllocateMemory(WIPE_BUFFER_SIZE);
		if (!lpWipeBuffer)
		{
			goto DeleteWipeEnd;
		}
	}
	else
	{
		lpWipeBuffer = 0;
	}

	EmptyTheMessageQue();

	// Setup our modeless dialog box for wiping or deleting the files.
	//................................................................
	bCancelOperation = FALSE;
	hDialogModeLess = CreateDialog(hInst,TEXT("WIPEDELETE"),hMainWindow,
								  (DLGPROC)WipeDeleteProc);

	if (!hDialogModeLess)
	{
		ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
		goto DeleteWipeEnd;
	}
	// Start the avi clip.
	//....................
	if (bAviClipOK)
	{
		bAviClipOK = Animate_Play(hAviClip,0,-1,-1);
	}
	// Set confirmation to TRUE. Can be changed by the Yes to All
	// button.
	//...........................................................
	bSkipTheRest = FALSE;

	// Go into a loop and wipe/delete the files.
	//..........................................
	while(iNumberOfFiles > 0)
	{
		EmptyTheMessageQue();
		if (bCancelOperation == TRUE)
		{
			break;
		}
		// If we have more than one file we have to append the
		// file name to the path.
		//....................................................
		if (bMoreThanOne)
		{
			*lpFileInsert = 0;
			StringCbCatEx(szFileName,sizeof(szFileName),lpTempFilePtr,NULL,NULL,
						  dwStringSafeFlag);
			iFileNameLength = lstrlen(lpTempFilePtr);
		}
		// Get a pointer to the file name and file extension if
		// we need it later.
		//.....................................................
		lpFileExtension = PathFindExtension((LPCTSTR)szFileName);
		lpFileName = PathFindFileName((LPCTSTR)szFileName);

		// Destroy the icon if we used it.
		//................................
		if (hIcon)
		{
			DestroyIcon(hIcon);
			hIcon = 0;
		}
		// Let find the icon for the file.
		//................................
		hIcon = FindMyIcon((LPBYTE)&szFileName,lpFileExtension);

		// If we did not find one, use the default.
		//.........................................
		if (!hIcon)
		{
			hIcon = LoadImage(hInst,"I_FACEFROWN",IMAGE_ICON,32,32,LR_SHARED);
		}
		// Determine the files attributes so we can perform
		// the correct procedure.
		//.................................................
		dwFileAttributes = GetMyFileAttributes((LPBYTE)&szFileName);

		// If we have an error on this file we quit.
		//..........................................
		if (dwFileAttributes == 0xffffffff)
		{
			break;
		}
		// If we are wiping a file and it is on a compressed drive
		// be have to use random data.
		//........................................................
		bUseRandomData = FALSE;
		if (bWipeFiles && (dwFileAttributes & FILE_ATTRIBUTE_COMPRESSED))
		{
			bUseRandomData = TRUE;
		}
		// Determine if we have to display a message box asking if
		// we really want to delete or wipe this file.
		//........................................................
		if (!bSkipTheRest || (dwFileAttributes & dwCheckAttributes))
		{
			FlashMyIcon(FALSE);

			iResult = DialogBox(hInst,TEXT("CONFIRMWIPEDELETE"),hDialogModeLess,
							   (DLGPROC)ConfirmWipeDeleteProc);

			EmptyTheMessageQue();

			if (hDlgFont)
			{
				DeleteObject(hDlgFont);
				hDlgFont = 0;
			}
			// See if we had a system error in creating the dialog box.
			//.........................................................
			if (iResult == -1)
			{
				ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
				goto DeleteWipeEnd;
			}
			// Quit if we canceled.
			//.....................
			if (iResult == IDCANCEL)
			{
				bCancelOperation = TRUE;
				break;
			}
			// If we said no.
			//...............
			if (iResult == IDC_MYNOC)
			{
				// Point to the next file selected. Get past the
				// trailing null byte.
				//..............................................
				lpTempFilePtr += (int)(iFileNameLength + 1);

				iNumberOfFiles--;
				continue;
			}
		}
		// Display the icon of the file.
		//..............................
		if (hIcon2)
		{
			DestroyIcon(hIcon2);
		}
		hIcon2 = hIcon;
		hIcon = 0;

		SendMessage(GetDlgItem(hDialogModeLess,IDC_ICON1),STM_SETICON,(WPARAM)hIcon2,0);

		// Display the file name in the dialog box.
		//.........................................
		SetDlgItemTextFmt(hDialogModeLess,IDC_WDFILENAME,
						 (LPCTSTR)GetDisplayName(&shfi1,(LPCTSTR)&szFileName));

		EmptyTheMessageQue();

		// Point to the next file selected. Get past the
		// trailing null byte.
		//..............................................
		lpTempFilePtr += (int)(iFileNameLength + 1);

		// Reset the file attributes so we can delete or wipe it
		// no matter what.
		//......................................................
		bResult = SetMyFileAttributes((LPBYTE)&szFileName,FILE_ATTRIBUTE_NORMAL);
		if (!bResult)
		{
			break;
		}
		// We really want to delete or wipe this file.
		//............................................
		if (!bWipeFiles)
		{
			bResult = DeleteMyFile((LPTSTR)&szFileName);
			if (!bResult)
			{
				break;
			}
			if (iTotalFiles < 15)
			{
				Sleep(100);
			}
		}
		else
		{
			// We want to wipe the files.
			//...........................
			if (bUseRandomData)
			{
				bResult = CompressedWipe((LPBYTE)&szFileName);
				if (!bResult)
				{
					break;
				}
			}
			else
			{
				bResult = GovernmentWipe((LPBYTE)&szFileName);
				if (!bResult)
				{
					break;
				}
			}
		}
		// Update the statement on the number of files wiped or deleted.
		// Print running stats.
		//..............................................................
		iFilesWiped++;

		if (bWipeFiles)
		{
			StringCbPrintf((LPTSTR)&szOutBuffer,sizeof(szOutBuffer),(LPCTSTR)&szFilesWiped,
					        iFilesWiped,iTotalFiles);
		}
		else
		{
			StringCbPrintf((LPTSTR)&szOutBuffer,sizeof(szOutBuffer),(LPCTSTR)&szFilesDeleted,
							iFilesWiped,iTotalFiles);
		}
		SetDlgItemText(hDialogModeLess,IDC_STATEMENT1,(LPCTSTR)&szOutBuffer);

		// Update the progress bar for deleting files.
		//............................................
		if (!bWipeFiles)
		{
			SendMessage(GetDlgItem(hDialogModeLess,IDC_PROGRESS),PBM_STEPIT,0,0);
		}

		iNumberOfFiles--;
	}
	// Print the final stats.
	//.......................
	if (bWipeFiles)
	{
		StringCbPrintf((LPTSTR)&szOutBuffer,sizeof(szOutBuffer),(LPCTSTR)&szFilesWiped,
						iFilesWiped,iTotalFiles);
	}
	else
	{
		StringCbPrintf((LPTSTR)&szOutBuffer,sizeof(szOutBuffer),(LPCTSTR)&szFilesDeleted,
						iFilesWiped,iTotalFiles);
	}
	SetDlgItemText(hDialogModeLess,IDC_STATEMENT1,(LPCTSTR)&szOutBuffer);

	// Set the position of the progress bar to 100% if we did not quit
	// or exit with an error
	//................................................................
	if (iFilesWiped == iTotalFiles)
	{
		if (bWipeFiles)
		{
			SendMessage(GetDlgItem(hDialogModeLess,IDC_PROGRESS),PBM_SETPOS,(WPARAM)200,0);
		}
		else
		{
			SendMessage(GetDlgItem(hDialogModeLess,IDC_PROGRESS),PBM_SETPOS,
					   (WPARAM)iTotalFiles,0);
		}
	}
	// Make sure bCancelOperation is set to FALSE.
	//............................................
	bCancelOperation = FALSE;

	// Stop the avi clip.
	//...................
	if (bAviClipOK)
	{
		bAviClipOK = Animate_Stop(hAviClip);
	}
	// Change the cancel button to ok.
	//................................
	SetDlgItemText(hDialogModeLess,IDCANCEL,TEXT("&OK"));

	FlashMyIcon(TRUE);

	// Wait until we close the dialog box to exit.
	//............................................
	while(TRUE)
	{
		CheckForMessages();
		if (bCancelOperation == TRUE)
		{
			break;
		}
	}
	// Clean up after ourselves.
	//..........................
	DeleteWipeEnd:

	FlashMyIcon(FALSE);

	if (hIcon)
	{
		DestroyIcon(hIcon);
		hIcon = 0;
	}
	if (hIcon2)
	{
		DestroyIcon(hIcon2);
		hIcon2 = 0;
	}
	// Close the avi clip.
	//...................
	if (bAviClipOK)
	{
		Animate_Close(hAviClip);
	}
	if (hDialogModeLess)
	{
		DestroyWindow(hDialogModeLess);
	}
	if (!lpBuffer && lpFileReturn)
	{
		ZeroMemory(lpFileReturn,((64*1024)-1));
		DeallocateMemory(lpFileReturn);
	}
	if (lpWipeBuffer)
	{
		ZeroMemory(lpWipeBuffer,WIPE_BUFFER_SIZE);
		DeallocateMemory(lpWipeBuffer);
		lpWipeBuffer = 0;
	}

	bCancelOperation = FALSE;
	ChangeHelpTopic(dwOldHelpTopic);
	if (!lpBuffer)
	{
		bProcessInProgress = FALSE;
	}
}

// CALLBACK procedure for the Wipe/Delete dialog box.
//...................................................
LRESULT CALLBACK WipeDeleteProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			UINT		uiMessage;
			TCHAR		szBuffer[64];

			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);
			SetBoldFont2(hDlg,IDC_STATEMENT1);

			// Setup the caption for the dialog box.
			//......................................
			if (bWipeFiles)
			{
				uiMessage = IDS_WIPINGFILES;
			}
			else
			{
				uiMessage = IDS_DELETINGFILES;
			}
			LoadString(hInst,uiMessage,szBuffer,sizeof(szBuffer));
			SendMessage(hDlg,WM_SETTEXT,0,(LPARAM)(LPCTSTR)szBuffer);

			// Set the wiping/deleting message.
			//.................................
			if (bWipeFiles)
			{
				uiMessage = IDS_FILESWIPING;
			}
			else
			{
				uiMessage = IDS_FILESDELETING;
			}
			LoadString(hInst,uiMessage,szBuffer,sizeof(szBuffer));
			SetDlgItemText(hDlg,IDC_WDOPERATION,(LPCTSTR)szBuffer);

			// Open the avi clip and display its first frame
			// in the animation control.
			//..............................................
			hAviClip = GetDlgItem(hDlg,IDC_ANIMATE);
			bAviClipOK = Animate_Open(hAviClip,FILE_NUKE);

			// Setup the range and step increment for the progress bar.
			//.........................................................
			if (bWipeFiles)
			{
				SendMessage(GetDlgItem(hDlg,IDC_PROGRESS),PBM_SETRANGE32,0,(LPARAM)200);
			}
			else
			{
				SendMessage(GetDlgItem(hDlg,IDC_PROGRESS),PBM_SETRANGE32,
						    0,(LPARAM)iNumberOfFiles);
			}
			SendMessage(GetDlgItem(hDlg,IDC_PROGRESS),PBM_SETSTEP,(WPARAM)iStepIncrement,0);

			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			SetFocus(GetDlgItem(hDlg,IDCANCEL));
			return(FALSE);
		}

		case WM_ACTIVATE:
		{
			if (wParam == 0)
			{
				hDlgCurrent = NULL;
			}
			else
			{
				hDlgCurrent = hDlg;
			}
			return(FALSE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				// Inform the procedure that we want to quit.
				//...........................................
				case IDCANCEL:
				{
					bCancelOperation = TRUE;
				}
				break;
			}
		}
		break;

		case WM_DESTROY:
		{
			if (hDlgFont2)
			{
				DeleteObject(hDlgFont2);
				hDlgFont2 = 0;
			}
			hDialogModeLess = NULL;
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// Perform a government wipe on a file. 
// Return FALSE if we have an error.
//.....................................
BOOL GovernmentWipe(LPBYTE lpFileName)
{
	ULARGE_INTEGER		li;
	ULARGE_INTEGER		liLoop;
	DWORD				dwTimes3;
	DWORD				dwTimes;
	HANDLE				hWipeHandle;
	DWORD				dwBytesRead;
	DWORD				dwBytesToRead;
	BOOL				bResult;
	BOOL				bFinalResult = FALSE;
	BYTE				NotEqual;
	DWORD				dwfwc = cfg.dwFinalWipeCharacter;

	dwTimes = cfg.dwRepeatWipeProc;

	// Open the file.
	//...............
	hWipeHandle = CreateMyFile(lpFileName,GENERIC_READ | GENERIC_WRITE,
							   0,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
	if (!hWipeHandle)
	{
		goto GovWipeEnd;
	}
	// Get the size of the file.
	//..........................
	li.QuadPart = GetMyFileSize(lpFileName,hWipeHandle);
	if (li.QuadPart == -1)
	{
		goto GovWipeEnd;
	}
	// Lets wipe the file.
	//....................
	while(dwTimes > 0)
	{
		EmptyTheMessageQue();
		if (bCancelOperation == TRUE)
		{
			goto GovWipeEnd;
		}
		dwTimes3 = 3;

		// Do the write of the 1's and 0's three times.
		//.............................................
		while(dwTimes3 > 0)
		{
			// Fill the buffer with 1's to overwrite the file with.
			//.....................................................
			FillMemory(lpWipeBuffer,WIPE_BUFFER_SIZE,0xff);
			bResult = GovernmentOverWrite(lpFileName,hWipeHandle,li.QuadPart,lpWipeBuffer);
			if (!bResult)
			{
				goto GovWipeEnd;
			}
			ZeroMemory(lpWipeBuffer,WIPE_BUFFER_SIZE);
			bResult = GovernmentOverWrite(lpFileName,hWipeHandle,li.QuadPart,lpWipeBuffer);
			if (!bResult)
			{
				goto GovWipeEnd;
			}
			dwTimes3--;
		}
		// Write the final dwFinalWipeCharacter to the file.
		//..................................................
		FillMemory(lpWipeBuffer,WIPE_BUFFER_SIZE,
				   LOBYTE(LOWORD(cfg.dwFinalWipeCharacter)));
		bResult = GovernmentOverWrite(lpFileName,hWipeHandle,li.QuadPart,lpWipeBuffer);
		if (!bResult)
		{
			goto GovWipeEnd;
		}
		liLoop.QuadPart = 0;
		liLoop.QuadPart = SetMyFilePointer(lpFileName,hWipeHandle,liLoop.QuadPart,FILE_BEGIN);
		if (liLoop.QuadPart == -1)
		{
			goto GovWipeEnd;
		}
		liLoop.QuadPart = li.QuadPart;
		while(liLoop.QuadPart > 0)
		{
			if (liLoop.QuadPart > WIPE_BUFFER_SIZE)
			{
				dwBytesToRead = WIPE_BUFFER_SIZE;
				liLoop.QuadPart -= WIPE_BUFFER_SIZE;
			}
			else
			{
				dwBytesToRead = liLoop.LowPart;
				liLoop.QuadPart = 0;
			}
			bResult = ReadMyFile(lpFileName,hWipeHandle,lpWipeBuffer,
								 dwBytesToRead,&dwBytesRead,NULL);

			// If we did not read in the required number of bytes.
			//....................................................
			if (dwBytesRead != dwBytesToRead)
			{
				SetLastError(IDS_BYTESREADNOTEQUALTOREQUEST);
				ErrorProcedure((LPTSTR)lpFileName,IDS_READ,MB_OK);
				bResult = FALSE;
				goto GovWipeEnd;
			}
			if (!bResult)
			{
				goto GovWipeEnd;
			}
			// Check the buffer to make sure it is the same
			// as the final wipe character.
			//.............................................
			__asm
			{
				mov		edi,lpWipeBuffer
				mov		al,byte ptr dwfwc
				mov		ecx,dwBytesRead
				repe	scasb
				setne	NotEqual
			}
			if (NotEqual)
			{
				SetLastError(IDS_WIPEVERIFYERROR);
				ErrorProcedure(lpFileName,IDS_WIPINGFILES,MB_OK);
				goto GovWipeEnd;
			}
			// Update the status bar to reflect this file.
			//............................................
			if (bUpdateTheStatusBar)
			{
				liStats.QuadPart += dwBytesRead;
				while(liStats.QuadPart >= liHalfPercentDup.QuadPart)
				{
					SendMessage(GetDlgItem(hDialogModeLess,IDC_PROGRESS),PBM_STEPIT,0,0);
					liStats.QuadPart -= liHalfPercentDup.QuadPart;
				}
			}
		}
		dwTimes--;
	}
	bFinalResult = TRUE;

	GovWipeEnd:

	// Close and delete the file.
	//...........................
	CloseMyHandle(lpFileName,hWipeHandle);
	DeleteMyFile(lpFileName);
	return(bFinalResult);
}

// Perform a wipe on a file on a compressed drive.
// Return FALSE if we have an error.
//................................................
BOOL CompressedWipe(LPBYTE lpFileName)
{
	ULARGE_INTEGER	li;
	HANDLE			hWipeHandle;
	DWORD			dwTimes;
	DWORD			dwTimes3;
	BOOL			bResult;
	BOOL			bFinalResult = FALSE;

	dwTimes = cfg.dwRepeatWipeProc;

	// Open the file.
	//...............
	hWipeHandle = CreateMyFile(lpFileName,GENERIC_READ | GENERIC_WRITE,
							   0,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
	if (!hWipeHandle)
	{
		goto CompWipeEnd;
	}
	// Get the size of the file.
	//..........................
	li.QuadPart = GetMyFileSize(lpFileName,hWipeHandle);
	if (li.QuadPart == -1)
	{
		goto CompWipeEnd;
	}
	// Wipe the file with random data.
	//................................
	while(dwTimes > 0)
	{
		dwTimes3 = 3;

		while(dwTimes3 > 0)
		{
			bResult = CompressedOverWrite(lpFileName,hWipeHandle,li.QuadPart,lpWipeBuffer);
			if (!bResult)
			{
				goto CompWipeEnd;
			}
			dwTimes3--;
		}
		dwTimes--;
	}
	bFinalResult = TRUE;

	CompWipeEnd:

	// Close and delete the file.
	//...........................
	CloseMyHandle(lpFileName,hWipeHandle);
	DeleteMyFile(lpFileName);
	return(bFinalResult);
}

// Overwrite the contents of a file using the
// government wipe procedure. Returns FALSE
// if we have an error.
//...........................................
BOOL GovernmentOverWrite(LPBYTE lpFileName, HANDLE hFile, __int64 liFileSize, LPBYTE lpBuffer)
{
	ULARGE_INTEGER	li;
	DWORD			dwBytesWritten;
	BOOL			bResult = TRUE;

	li.QuadPart = 0;
	li.QuadPart = SetMyFilePointer(lpFileName,hFile,li.QuadPart,FILE_BEGIN);
	if (li.QuadPart == -1)
	{
		bResult = FALSE;
		goto GovEnd;
	}
	li.QuadPart = liFileSize;
	while(li.QuadPart != 0)
	{
		if (li.QuadPart < WIPE_BUFFER_SIZE)
		{
			dwBytesWritten = li.LowPart;
			li.QuadPart = 0;
		}
		else
		{
			dwBytesWritten = WIPE_BUFFER_SIZE;
			li.QuadPart -= WIPE_BUFFER_SIZE;
		}
		bResult = WriteMyFile(lpFileName,hFile,lpWipeBuffer,
							  dwBytesWritten,&dwBytesWritten,NULL);
		if (!bResult)
		{
			goto GovEnd;
		}
		bResult = FlushMyFile(lpFileName,hFile);
		if (!bResult)
		{
			goto GovEnd;
		}
		EmptyTheMessageQue();
		if (bCancelOperation == TRUE)
		{
			bResult = FALSE;
			goto GovEnd;
		}
		// Update the status bar to reflect this file.
		//............................................
		if (bUpdateTheStatusBar)
		{
			liStats.QuadPart += dwBytesWritten;
			while(liStats.QuadPart >= liHalfPercentDup.QuadPart)
			{
				SendMessage(GetDlgItem(hDialogModeLess,IDC_PROGRESS),PBM_STEPIT,0,0);
				liStats.QuadPart -= liHalfPercentDup.QuadPart;
			}
		}
	}

	GovEnd:
	return(bResult);
}

// Overwrite the contents of a file using the
// compressed wipe procedure. Returns FALSE
// if we have an error.
//...........................................
BOOL CompressedOverWrite(LPBYTE lpFileName, HANDLE hFile, __int64 liFileSize, LPBYTE lpBuffer)
{
	ULARGE_INTEGER	li;
	LPBYTE			lpBufferDup;
	DWORD			dwRepeats;
	DWORD			dwBytesWritten;
	BOOL			bResult = TRUE;

	li.QuadPart = 0;
	li.QuadPart = SetMyFilePointer(lpFileName,hFile,li.QuadPart,FILE_BEGIN);
	if (li.QuadPart == -1)
	{
		bResult = FALSE;
		goto CompEnd;
	}
	li.QuadPart = liFileSize;

	while(li.QuadPart != 0)
	{
		// First fill up the buffer with random data from the
		// random bits bin.
		//...................................................
		lpBufferDup = lpBuffer;
		dwRepeats = (WIPE_BUFFER_SIZE/RBB_LENGTH);
		
		// Fill up the wipe buffer with random data.
		//..........................................
		while(dwRepeats != 0)
		{
			StirTheBits();
			CopyMemory(lpBufferDup,pRandBitsBin,RBB_LENGTH);
			lpBufferDup += RBB_LENGTH;
			dwRepeats--;
		}
		// Now overwrite the data on disk with random data.
		//.................................................
		if (li.QuadPart < WIPE_BUFFER_SIZE)
		{
			dwBytesWritten = li.LowPart;
			li.QuadPart = 0;
		}
		else
		{
			dwBytesWritten = WIPE_BUFFER_SIZE;
			li.QuadPart -= WIPE_BUFFER_SIZE;
		}
		bResult = WriteMyFile(lpFileName,hFile,lpBuffer,dwBytesWritten,
							  &dwBytesWritten,NULL);
		if (!bResult)
		{
			goto CompEnd;
		}
		bResult = FlushMyFile(lpFileName,hFile);
		if (!bResult)
		{
			goto CompEnd;
		}
		EmptyTheMessageQue();
		if (bCancelOperation == TRUE)
		{
			bResult = FALSE;
			goto CompEnd;
		}
		// Update the status bar to reflect this file.
		//............................................
		if (bUpdateTheStatusBar)
		{
			liStats.QuadPart += dwBytesWritten;
			while(liStats.QuadPart >= liHalfPercentDup.QuadPart)
			{
				SendMessage(GetDlgItem(hDialogModeLess,IDC_PROGRESS),PBM_STEPIT,0,0);
				liStats.QuadPart -= liHalfPercentDup.QuadPart;
			}
		}
	}

	CompEnd:
	return(bResult);
}

// CALLBACK procedure for asking confirmation on wiping or
// deleting the file.
//........................................................
LRESULT CALLBACK ConfirmWipeDeleteProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			LARGE_INTEGER		li;
			WIN32_FIND_DATA		FindData;
			TCHAR				szInBuffer[332];
			TCHAR				szFormatedNumber[64];
			HANDLE				hSearchHandle;
			FILETIME			ftLocalTime;
			SYSTEMTIME			stLocalTime;
			TCHAR				szLocalDate[128];
			TCHAR				szLocalTime[64];
			UINT				uiStatement;

			// Clear a few variables.
			//.......................
			ZeroMemory(&szFormatedNumber,sizeof(szFormatedNumber));
			ZeroMemory(&szLocalDate,sizeof(szLocalDate));
			ZeroMemory(&szLocalTime,sizeof(szLocalTime));
			ZeroMemory(&szInBuffer,sizeof(szInBuffer));

			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);
			SetBoldFont(hDlg,IDC_QUESTION1,0);

			LoadString(hInst,IDS_CONFIRMATION,szInBuffer,sizeof(szInBuffer));
			SendMessage(hDlg,WM_SETTEXT,0,(LPARAM)(LPCTSTR)szInBuffer);
			ZeroMemory(&szInBuffer,sizeof(szInBuffer));

			// Set the statement and file name.
			//.................................
			if (bWipeFiles)
			{
				uiStatement = IDS_SELECTEDWIPE;
			}
			else
			{
				uiStatement = IDS_SELECTEDDELETE;
			}
			LoadString(hInst,uiStatement,(LPTSTR)&szInBuffer,sizeof(szInBuffer));
			SetDlgItemText(hDlg,IDC_STATEMENT1,(LPCTSTR)&szInBuffer);
			ZeroMemory(&szInBuffer,sizeof(szInBuffer));
			SetDlgItemTextFmt(hDlg,IDC_CONTAINS,
							 (LPCTSTR)GetDisplayName(&shfi1,(LPCTSTR)&szFileName));

			if (hIcon)
			{
				SendMessage(GetDlgItem(hDlg,IDC_ICON1),STM_SETICON,(WPARAM)hIcon,0);
			}
			ZeroMemory(&szInBuffer,sizeof(szInBuffer));

			// Setup the file information for the file.
			//.........................................
			hSearchHandle = FindFirstFile((LPCTSTR)&szFileName,&FindData);
			FindClose(hSearchHandle);
			li.LowPart = FindData.nFileSizeLow;
			li.HighPart = FindData.nFileSizeHigh;
			_i64toa(li.QuadPart,(LPBYTE)&szInBuffer,10);
			GetNumberFormat(LOCALE_USER_DEFAULT,0,(LPCTSTR)&szInBuffer,
				            &nFormatInfo,(LPTSTR)&szFormatedNumber,sizeof(szFormatedNumber));
			StringCbPrintf(szInBuffer,sizeof(szInBuffer),lpszSizeFormat,szFormatedNumber);
			SetDlgItemText(hDlg,IDC_SIZE1,(LPCTSTR)szInBuffer);
			ZeroMemory(&szInBuffer,sizeof(szInBuffer));

			// Now do the time and date.
			//..........................
			FileTimeToLocalFileTime((LPFILETIME)&FindData.ftLastWriteTime,
									(LPFILETIME)&ftLocalTime);
			FileTimeToSystemTime((LPFILETIME)&ftLocalTime,(LPSYSTEMTIME)&stLocalTime);

			// Format the date.
			//.................
			GetDateFormat(LOCALE_USER_DEFAULT,DATE_LONGDATE,&stLocalTime,
				          NULL,(LPTSTR)&szLocalDate,sizeof(szLocalDate));

			// Format the time.
			//.................
			GetTimeFormat(LOCALE_USER_DEFAULT,TIME_FORCE24HOURFORMAT,
						  &stLocalTime,NULL,(LPTSTR)&szLocalTime,sizeof(szLocalTime));
			StringCbPrintf(szInBuffer,sizeof(szInBuffer),lpszDateTimeFormat,&szLocalDate,
						   &szLocalTime);
			SetDlgItemText(hDlg,IDC_DATETIME1,(LPCTSTR)szInBuffer);

			// Setup the attributes.
			//......................
			ZeroMemory(&szInBuffer,sizeof(szInBuffer));
			StringCbPrintf(szInBuffer,sizeof(szInBuffer),lpszAttribFormat,
				(dwFileAttributes & FILE_ATTRIBUTE_HIDDEN) ? lpszYes : lpszNo,
				(dwFileAttributes & FILE_ATTRIBUTE_SYSTEM) ? lpszYes : lpszNo,
				(dwFileAttributes & FILE_ATTRIBUTE_READONLY) ? lpszYes : lpszNo);
			SetDlgItemText(hDlg,IDC_ATTRIBUTES,(LPCTSTR)szInBuffer);

			// Display the proper question.
			//.............................
			ZeroMemory(&szInBuffer,sizeof(szInBuffer));

			if (bWipeFiles)
			{
				uiStatement = IDS_REALLYWIPE;
			}
			else
			{
				uiStatement = IDS_REALLYDELETE;
			}
			LoadString(hInst,uiStatement,(LPTSTR)&szInBuffer,sizeof(szInBuffer));
			SetDlgItemText(hDlg,IDC_QUESTION1,(LPCTSTR)&szInBuffer);

			// If we only have one file, disable the Yes to All button.
			//.........................................................
			if (iNumberOfFiles == 1)
			{
				EnableWindow(GetDlgItem(hDlg,IDC_YESTOALLC),FALSE);
			}
			// Center the window.
			//...................
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			return(TRUE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDC_MYYESC:
				{
					EndDialog(hDlg,IDC_MYYESC);
				}
				break;

				case IDC_YESTOALLC:
				{
					bSkipTheRest = TRUE;
					EndDialog(hDlg,IDC_YESTOALLC);
				}
				break;

				case IDC_MYNOC:
				{
					EndDialog(hDlg,IDC_MYNOC);
				}
				break;

				case IDCANCEL:
				{
					EndDialog(hDlg,IDCANCEL);
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
			break;
		}

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;
	
		default:
			return(FALSE);
	}
	return(TRUE);
}

// Wipe a section of a pad file that we used. Use lpKeyBuffer2.
//.............................................................
BOOL WipePadSection(LPTSTR FileName, HANDLE hFile, __int64 StartPosition, __int64 Length)
{
	DWORD			dwTimes3;
	DWORD			dwTimes;
	DWORD			bResult = TRUE;
	LARGE_INTEGER	liLoop;
	int				iResult;
	TCHAR			szOutBuffer[512];
	TCHAR			szFormatBuffer[128];
	DWORD			dwBytesRead;
	DWORD			dwBytesToRead;
	BYTE			NotEqual;
	DWORD			dwfwc = cfg.dwFinalWipeCharacter;

	// See if we really want to wipe this section of the pad file.
	//............................................................
	LoadString(hInst,IDS_CONFIRMPADWIPE,(LPTSTR)&szFormatBuffer,sizeof(szFormatBuffer));

	StringCbPrintf((LPTSTR)&szOutBuffer,sizeof(szOutBuffer),(LPCTSTR)&szFormatBuffer,
					FileName);

	iResult = MessageBoxProc(hMainWindow,IDS_CONFIRMATION,(UINT)szOutBuffer,
							 MB_ICONQUESTION | MB_YESNO | MB_HELP,MB_ICONQUESTION,0);

	if (iResult == IDNO)
	{
		goto WipePadEnd;
	}
	// Lets wipe the pad section.
	//...........................
	dwTimes = cfg.dwRepeatWipeProc;

	while(dwTimes > 0)
	{
		EmptyTheMessageQue();

		dwTimes3 = 3;

		// Do the write of the 1's and 0's three times.
		//.............................................
		while(dwTimes3 > 0)
		{
			// Fill the buffer with 1's to overwrite the file with.
			//.....................................................
			FillMemory(lpKeyBuffer2,ENC_BUFFER_SIZE,0xff);
			bResult = PadOverWrite(FileName,hFile,StartPosition,Length,lpKeyBuffer2);
			if (!bResult)
			{
				goto WipePadEnd;
			}
			ZeroMemory(lpKeyBuffer2,ENC_BUFFER_SIZE);
			bResult = PadOverWrite(FileName,hFile,StartPosition,Length,lpKeyBuffer2);
			if (!bResult)
			{
				goto WipePadEnd;
			}
			dwTimes3--;
		}
		// Write the final wipe character to the section.
		//...............................................
		FillMemory(lpKeyBuffer2,ENC_BUFFER_SIZE,LOBYTE(LOWORD(cfg.dwFinalWipeCharacter)));
		bResult = PadOverWrite(FileName,hFile,StartPosition,Length,lpKeyBuffer2);
		if (!bResult)
		{
			goto WipePadEnd;
		}
		// Reread the pad section to make sure it is correct.
		//...................................................
		liLoop.QuadPart = StartPosition;
		liLoop.QuadPart = SetMyFilePointer(FileName,hFile,liLoop.QuadPart,FILE_BEGIN);
		if (liLoop.QuadPart == -1)
		{
			bResult = FALSE;
			goto WipePadEnd;
		}
		liLoop.QuadPart = Length;
		while(liLoop.QuadPart > 0)
		{
			if (liLoop.QuadPart > ENC_BUFFER_SIZE)
			{
				dwBytesToRead = ENC_BUFFER_SIZE;
				liLoop.QuadPart -= ENC_BUFFER_SIZE;
			}
			else
			{
				dwBytesToRead = liLoop.LowPart;
				liLoop.QuadPart = 0;
			}
			bResult = ReadMyFile((LPTSTR)FileName,hFile,lpKeyBuffer2,
								  dwBytesToRead,&dwBytesRead,NULL);

			// If we did not read in the required number of bytes.
			//....................................................
			if (dwBytesRead != dwBytesToRead)
			{
				SetLastError(IDS_BYTESREADNOTEQUALTOREQUEST);
				ErrorProcedure((LPTSTR)FileName,IDS_READ,MB_OK);
				bResult = FALSE;
				goto WipePadEnd;
			}
			if (!bResult)
			{
				goto WipePadEnd;
			}
			// Check the buffer to make sure it is the same
			// as the final wipe character.
			//.............................................
			__asm
			{
				mov		edi,lpKeyBuffer2
				mov		al,byte ptr dwfwc
				mov		ecx,dwBytesRead
				repe	scasb
				setne	NotEqual
			}
			if (NotEqual)
			{
				SetLastError(IDS_WIPEVERIFYERROR);
				ErrorProcedure(FileName,IDS_WIPINGFILES,MB_OK);
				goto WipePadEnd;
			}
		}
		dwTimes--;
	}
	if (bResult)
	{
		LoadString(hInst,IDS_PADWIPECOMPLETE,(LPTSTR)&szFormatBuffer,sizeof(szFormatBuffer));

		StringCbPrintf((LPTSTR)&szOutBuffer,sizeof(szOutBuffer),(LPCTSTR)&szFormatBuffer,
						FileName);

		MessageBoxProc(hMainWindow,IDS_ADVISORY,(UINT)szOutBuffer,
					   MB_ICONEXCLAMATION | MB_OK | MB_HELP,MB_ICONEXCLAMATION,0);
	}

  WipePadEnd:

	return(bResult);
}

// Pad Overwrite procedure.
//.........................
BOOL PadOverWrite(LPTSTR FileName, HANDLE hFile, __int64 StartPosition,
				  __int64 Length, LPBYTE lpBuffer)
{
	LARGE_INTEGER	li;
	BOOL			bResult = TRUE;
	DWORD			dwBytesWritten;

	li.QuadPart = StartPosition;
	li.QuadPart = SetMyFilePointer(FileName,hFile,li.QuadPart,FILE_BEGIN);
	if (li.QuadPart == -1)
	{
		bResult = FALSE;
		goto PadEnd;
	}
	li.QuadPart = Length;
	while(li.QuadPart != 0)
	{
		if (li.QuadPart < ENC_BUFFER_SIZE)
		{
			dwBytesWritten = li.LowPart;
			li.QuadPart = 0;
		}
		else
		{
			dwBytesWritten = ENC_BUFFER_SIZE;
			li.QuadPart -= ENC_BUFFER_SIZE;
		}
		bResult = WriteMyFile(FileName,hFile,lpBuffer,dwBytesWritten,&dwBytesWritten,NULL);
		if (!bResult)
		{
			goto PadEnd;
		}
		bResult = FlushMyFile(FileName,hFile);
		if (!bResult)
		{
			goto PadEnd;
		}
		EmptyTheMessageQue();
	}

  PadEnd:

	return(bResult);
}

// Wipe one file. Returns FALSE for no error.
//...........................................
BOOL WipeMyFile(LPBYTE lpFileToWipe, BOOL bDlgBox)
{
	DWORD		dwFileAttributes;
	BOOL		bResult;
	BOOL		bUseRandomData;
	BOOL		bErr = TRUE;

	bUpdateTheStatusBar = FALSE;
	lpWipeBuffer = AllocateMemory(WIPE_BUFFER_SIZE);
	if (!lpWipeBuffer)
	{
		goto WipeEnd;
	}
	// Get the file's attributes.
	//...........................
	dwFileAttributes = GetMyFileAttributes((LPBYTE)lpFileToWipe);

	if (dwFileAttributes == 0xffffffff)
	{
		goto WipeEnd;
	}
	// Check to see if the file is on a compressed drive or not.
	//..........................................................
	bUseRandomData = FALSE;
	if (dwFileAttributes & FILE_ATTRIBUTE_COMPRESSED)
	{
		bUseRandomData = TRUE;
	}
	// Display a modless dialog box for wiping the file.
	//..................................................
	if (bDlgBox)
	{
		lpFileName = PathFindFileName((LPCTSTR)lpFileToWipe);

		hDlgCurrent = CreateDialog(hInst,TEXT("WIPINGINTERMEDIATE"),hMainWindow,
								  (DLGPROC)CenterWipeDlgBoxProc);

		if (!hDlgCurrent)
		{
			ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
			goto WipeEnd;
		}
	}
	if (bUseRandomData)
	{
		bResult = CompressedWipe((LPBYTE)lpFileToWipe);
	}
	else
	{
		bResult = GovernmentWipe((LPBYTE)lpFileToWipe);
	}
	if (bResult)
	{
		bErr = FALSE;
	}
	if (bDlgBox && hDlgCurrent)
	{
		Sleep(700);
		DestroyWindow(hDlgCurrent);
		hDlgCurrent = 0;
		ReleaseCapture();
	}

	WipeEnd:

	if (lpWipeBuffer)
	{
		ZeroMemory(lpWipeBuffer,WIPE_BUFFER_SIZE);
		DeallocateMemory(lpWipeBuffer);
		lpWipeBuffer = 0;
	}
	
	return(bErr);
}

// Wipe a file after it has been encrypted.
//.........................................
BOOL ConfirmWipeMyFile(UINT uAsk, LPBYTE lpFileToWipe, BOOL bDlgBox)
{
	BOOL		bResult;
	int			iResult;
	DWORD		dwCheckAttributes;
	BOOL		bUseRandomData;
	BOOL		bErr = TRUE;
	TCHAR		szOutBuffer[512];
	TCHAR		szFormatBuffer[128];

	bWipeFiles = TRUE;

	dwCheckAttributes = (FILE_ATTRIBUTE_HIDDEN | FILE_ATTRIBUTE_SYSTEM |
						 FILE_ATTRIBUTE_READONLY);

	LoadString(hInst,uAsk,(LPTSTR)&szFormatBuffer,sizeof(szFormatBuffer));

	StringCbPrintf((LPTSTR)&szOutBuffer,sizeof(szOutBuffer),(LPCTSTR)&szFormatBuffer,
					lpFileToWipe);

	iResult = MessageBoxProc(hMainWindow,IDS_CONFIRMATION,(UINT)szOutBuffer,
							 MB_ICONQUESTION | MB_YESNO | MB_HELP,MB_ICONQUESTION,0);

	if (iResult == IDNO)
	{
		goto WipeEnd;
	}

	bUpdateTheStatusBar = FALSE;
	lpWipeBuffer = AllocateMemory(WIPE_BUFFER_SIZE);
	if (!lpWipeBuffer)
	{
		goto WipeEnd;
	}
	// Get the file's attributes.
	//...........................
	dwFileAttributes = GetMyFileAttributes((LPBYTE)lpFileToWipe);

	if (dwFileAttributes == 0xffffffff)
	{
		goto WipeEnd;
	}
	// Check to see if the file is on a compressed drive or not.
	//..........................................................
	bUseRandomData = FALSE;
	if (dwFileAttributes & FILE_ATTRIBUTE_COMPRESSED)
	{
		bUseRandomData = TRUE;
	}
	// Determine if we have to display a message box asking if
	// we really want to delete or wipe this file.
	//........................................................
	if (dwFileAttributes & dwCheckAttributes)
	{
		FlashMyIcon(FALSE);

		iNumberOfFiles = 1;

		CopyMemory(&szFileName,lpFileToWipe,MAX_PATH);
		lpFileExtension = PathFindExtension((LPCTSTR)szFileName);

		// Destroy the icon if we used it.
		//................................
		if (hIcon)
		{
			DestroyIcon(hIcon);
			hIcon = 0;
		}
		// Let find the icon for the file.
		//................................
		hIcon = FindMyIcon((LPBYTE)&szFileName,lpFileExtension);

		// If we did not find one, use the default.
		//.........................................
		if (!hIcon)
		{
			hIcon = LoadImage(hInst,"I_FACEFROWN",IMAGE_ICON,32,32,LR_SHARED);
		}
		// Confirm if we really want to delete this file.
		//...............................................
		iResult = DialogBox(hInst,TEXT("CONFIRMWIPEDELETE"),hMainWindow,
						   (DLGPROC)ConfirmWipeDeleteProc);

		EmptyTheMessageQue();

		// See if we had a system error in creating the dialog box.
		//.........................................................
		if (iResult == -1)
		{
			ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
			goto WipeEnd;
		}
		// Quit if we canceled.
		//.....................
		if (iResult == IDCANCEL || iResult == IDC_MYNOC)
		{
			goto WipeEnd;
		}
		// Reset the file attributes so we can delete or wipe it
		// no matter what.
		//......................................................
		bResult = SetMyFileAttributes((LPBYTE)&szFileName,FILE_ATTRIBUTE_NORMAL);
		if (!bResult)
		{
			goto WipeEnd;
		}
	}
	// Display a modless dialog box for wiping the file.
	//..................................................
	if (bDlgBox)
	{
		lpFileName = PathFindFileName((LPCTSTR)lpFileToWipe);

		hDlgCurrent = CreateDialog(hInst,TEXT("WIPINGINTERMEDIATE"),hMainWindow,
								  (DLGPROC)CenterWipeDlgBoxProc);

		if (!hDlgCurrent)
		{
			ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
			goto WipeEnd;
		}
	}
	// Use the appropriate wipe procedure.
	//....................................
	if (bUseRandomData)
	{
		bResult = CompressedWipe((LPBYTE)lpFileToWipe);
	}
	else
	{
		bResult = GovernmentWipe((LPBYTE)lpFileToWipe);
	}
	if (bDlgBox && hDlgCurrent)
	{
		Sleep(700);
		DestroyWindow(hDlgCurrent);
		hDlgCurrent = 0;
	}
	bErr = FALSE;
	
	WipeEnd:

	if (lpWipeBuffer)
	{
		ZeroMemory(lpWipeBuffer,WIPE_BUFFER_SIZE);
		DeallocateMemory(lpWipeBuffer);
		lpWipeBuffer = 0;
	}

	return(bErr);
}

// Center small modeless dialog boxes.
//....................................
LRESULT CALLBACK CenterWipeDlgBoxProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Setup the file name.
			//.....................
			SetDlgItemText(hDlg,IDC_MYFILETOWIPE,(LPCTSTR)lpFileName);

			// Center the dialog box.
			//.......................
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			SetCapture(hDlg);
			return FALSE;
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}
